 ; Ŀ
 ;   Mattress - move text to the right position relative to a matchline.   
 ;   Also fixes linetype, width, text layer, etc.                          
 ;   Copyright 1995, 2005, 2007, 2010 by Rocket Software Ltd.              
 ;   Valid only with purchase of genuine Rocket drawings.                  
 ; 

 ; Ŀ
 ;   Midx - middle justify text on a given point.                          
 ; 
 (DEFUN MIDX (enam pa / entt eleven nn72)
  (setq entt (entget enam))
  (setq eleven (cdr (assoc 11 entt)))
  (setq nn72 (assoc 72 entt))
  (entmod (subst (cons 72 4) (assoc 72 entt) entt))  ; change
  (setq entt (entget enam))                          ; get the changed edata
  (entmod (subst (cons 11 pa) (assoc 11 entt) entt))
 (princ))
 ; Ŀ
 ;   Midx - middle justify text on a given point.                          
 ; 

 ; Ŀ
 ;   Centx - convert text to centre justified text, move to a given point. 
 ; 
 (DEFUN CENTX (enam pa / aa eleven nn72 new10 dist angl new11 nu11)
  (setq aa (entget enam))
  (setq eleven (cdr (assoc 11 aa)))
  (setq nn72 (assoc 72 aa))
  (entmod (subst (cons 72 1) (assoc 72 aa) aa))  ; change
  (setq aa (entget enam))                        ; get the changed entity data
  (entmod (subst (cons 11 pa) (assoc 11 aa) aa))
 (princ))
 ; Ŀ
 ;   Centx end.                                                            
 ; 

 ; Ŀ
 ;   PW - set the width of a polyline, line or arc to 1.0 x Dimscale.      
 ; 
 (DEFUN PW (enam / entt dimscl typ)
  (setq entt (entget enam))
  (setq dimscl (misps))
  (setq typ (cdr (assoc 0 entt)))
  (cond ((or (= typ "LINE") (= typ "ARC"))
         (command "pedit" enam "y" "w" dimscl ""))
        ((or (= typ "POLYLINE") (= typ "LWPOLYLINE"))
         (command "pedit" enam "w" dimscl ""))
        (T (write-line "Wrong type.")))
 (princ))
 ; Ŀ
 ;   PW end.                                                               
 ; 

 ; Ŀ
 ;   Texas - find the centre of text.                                      
 ; 
 (DEFUN TEXAS (enam / aa bb rota cc dd bheigt bwidth llangg lldist ll ul lr ur)
  (setq aa (entget enam))
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
  (polar ll (angle ll ur) (/ (distance ll ur) 2.0)))
 ; Ŀ
 ;   Texas end.                                                            
 ; 

 ; Ŀ
 ;   Mattress - bounce text into the right position.                       
 ; 
 (DEFUN C:MATTRESS (/ *error* osmo tex texan texnam lin linen bigtex texcen
                                                       pagmid midlin rotex)
  (setvar "cmdecho" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (command "undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Ask for entities, get type and data for each.                         
 ; 
  (if (setq tex (entsel "\nText: "))
      (progn
           (setq texan (entget (setq texnam (car tex))))
           (setq ttyp (cdr (assoc 0 texan)))))
  (if (and texan (setq lin (entsel "and match line:  ")))
      (progn
           (setq linen (entget (setq linam (car lin))))
           (setq ltyp (cdr (assoc 0 linen)))))
  (if (and linen texan (= ttyp "TEXT")
           (or (= ltyp "LINE") (= ltyp "POLYLINE") (= ltyp "LWPOLYLINE")))
      (progn
 ; Ŀ
 ;   Set up variables, linetype, etc.                                      
 ; 
           (command "units" "2" "2" "1" "2" "0" "N")
           (if (null (tblsearch "ltype" "center"))
               (command "linetype" "l" "center" "acad" ""))
           (setq dimscl (misps))
 ; Ŀ
 ;   Make sure the text is the correct height and on the right layer.      
 ; 
           (setq texan (subst (cons 40 (* dimscl 4)) (assoc 40 texan) texan))
           (entmod (subst (cons 8 "Text") (assoc 8 texan) texan))
           (setq texan (entget texnam))
 ; Ŀ
 ;   Make sure the polyline is the correct width and linetype.             
 ; 
           (pw linam)
           (command "change" linam "" "p" "lt" "center" "")
           (setq linen (entget linam))
 ; Ŀ
 ;   Calculate the offset of the text from the line: 1/2 of the text       
 ;   height (1.5 x dimscale) + 1/2 of the pline width (1/4 x dimscale) +   
 ;   2 x dimscale so the actual distance from the line edge is twice       
 ;   dimscale.                                                             
 ; 
           (setq bigtex (* 5 dimscl)) ; changed
 ; Ŀ
 ;   Call Texas to find the geometric centre of the text entity.           
 ; 
           (setq texcen (texas texnam))
 ; Ŀ
 ;   Find the centre of the drawing.                                       
 ; 
           (setq extmax (getvar "extmax"))
           (setq extmin (getvar "extmin"))
           (setq extcen (list (/ (+ (car extmax) (car extmin)) 2)
                              (/ (+ (cadr extmax) (cadr extmin)) 2)))
 ; Ŀ
 ;   And find the middle and one end of the selected line or pline         
 ;   segment.                                                              
 ; 
           (setq midlin (osnap (cadr lin) "mid"))
           (setq endlin (osnap (cadr lin) "end"))
 ; Ŀ
 ;   Find the line angle, if matching text would be upside down then       
 ;   rotate it by 180 degrees.                                             
 ; 
           (setq lang (angle midlin endlin))
           (if (and (> lang (/ pi 2)) (<= lang (* pi 1.5)))
               (setq lang (- lang pi)))
 ; Ŀ
 ;   Rotate the text.                                                      
 ; 
           (entmod (subst (cons 50 lang) (assoc 50 texan) texan))
 ; Ŀ
 ;   Now want to move text to the middle of the line on the side away      
 ;   from the drawing centre and offset it by Bigtex.                      
 ; 
           (setq mang (angle extcen midlin))
           (setq mdis (+ bigtex (distance extcen midlin)))
           (setq pta (polar extcen mang mdis))
 ; Ŀ
 ;   Centre the text on the point pta.                                     
 ; 
           (midx texnam pta))
      (write-line "\nNothing happened."))
  (*error* ())
 (princ))